## R has a predefined package with the name "FaultTree" for performing FTA
 # To know more about the package, after loading it using the "library" command, type "?FaultTree" in the console

 # 1) Creating top event
 # Run the following command after removing "#" if "FaultTree" package is not installed
 # install.packages("FaultTree")
   library(FaultTree)
   Fault_Tree <- ftree.make(type="or",reversible_cond=TRUE, name="Internet Connection", name2="Failure")

 # 2) Creating intermediate events
   Fault_Tree <- addLogic(Fault_Tree, at=1, type="or", name="Hardware Issue")
   Fault_Tree <- addLogic(Fault_Tree, at=1, type="or", name="Software Issue")
   
 # 3) Creating basic events
   Fault_Tree <- addLatent(Fault_Tree, at=2, mttf=1.5,mttr=2,inspect=0.87, name="Router Malfunctioning")
   Fault_Tree <- addLatent(Fault_Tree, at=2, mttf=1.5,mttr=2,inspect=0.5, name="Power Supply is OFF")
   Fault_Tree <- addLatent(Fault_Tree, at=3, mttf=1.5,mttr=2,inspect=0.33, name="Change in Network", name2="and Internet settings")
   Fault_Tree <- addLatent(Fault_Tree, at=3, mttf=1.5,mttr=2,inspect=0.72, name="Driver not installed")
   
 # 4) Performing fault tree calculation
   Fault_Tree <- ftree.calc(Fault_Tree)
   
 # 5) Creating fault tree tabular subview
   ftree2table(Fault_Tree)
   
 # 6) Displaying fault tree in browser
   ftree2html(Fault_Tree, write_file=TRUE)
   browseURL('Fault_Tree.html')